<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id');

    public function dreams()
    {
        return $this->hasMany('App\Models\Dream');
    }

    public function country()
    {
        return $this->hasOne('App\Models\Country');
    }

    public function ratings()
    {
        return $this->hasMany('App\Models\Rating');
    }

    public function favorites()
    {
        return $this->hasMany('App\Models\Favorite');
    }

}